(function() {
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'collections/contacts/ContactCollection', 'models/contact/ContactModel', 'views/contact/ContactView', "views/menu/MenuView", 'views/contact/FormContactView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, ContactCollection, ContactModel, ContactView, MenuView, FormContactView) {
    var ContactListView;
    return ContactListView = class ContactListView extends Backbone.View {
      initialize(usr, previousView) {
        this.usr = usr;
        this.previousView = previousView;
        //#console.log 'contact list view'
        this.contactsCol = new ContactCollection();
        this.contactsCol.on('collectionFilled', this.collectionFilled, this);
        this.contactsCol.on('contact_deleted', this.contact_deleted, this);
        return this.NContactsPerPage = 500;
      }

      events() {
        return {
          'tap #id-ul-listContacts > li': 'btnContactClicked',
          'tap #id-btn-panel': 'btnPanelClicked',
          'keyup #id-input-search-contact': 'inputSearchChanged',
          'change #id-input-search-contact': 'inputSearchChanged',
          'pageshow': 'pageShown',
          'tap #id-btn-add-contact': 'btnAddContactClicked'
        };
      }

      render() {
        var template;
        //@$el.empty()
        template = Handlebars.templates['ContactListView'];
        this.$el.html(template({
          user: this.usr.toJSON(),
          canAddContact: this.usr.__can_edit_all_contacts() || this.usr.__can_edit_division_contacts()
        }));
        this.$el.find('#id-ul-listContacts').show();
        this.$el.attr('id', 'id-ContactListView');
        this.addSidePanel();
        return this.$el;
      }

      pageShown() {
        $('#id-ul-listContacts li').removeClass('contactSelected');
        return this.__get_contacts_collection();
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      collectionFilled() {
        this.$el.find('#id-spinner-all').hide();
        this.$el.find('#id-input-search-contact').textinput('enable');
        //col = @contactsCol.getRange(50)
        return this.update_contact_list();
      }

      update_contact_list(col) {
        var i, ulc;
        if (!col) {
          col = this.contactsCol.getRange(50);
        }
        ulc = this.$el.find('#id-ul-listContacts');
        ulc.empty();
        i = 0;
        _.each(col, (contact) => {
          var company, id, li, name;
          if (i < this.NContactsPerPage) {
            id = contact.i;
            name = contact.n;
            company = contact.c;
            if (!(_.isUndefined(name) || !name)) {
              li = `<li data-contactID='${id}' style='min-height: initial;'> <div style='display: table; width: 100%; vertical-align: middle;'> <div style='display: table-cell; width: 90%; vertical-align: middle;'> <span class='header' style='position: initial; display: block; float: left; width: 100%; max-width: initial;'>${name}</span> <span class='subheader1' style='position: initial; display: block; float: left; width: 100%; max-width: initial;'> ${!_.isUndefined(company) && company ? `<span class='fwi-agency ui-btn-left' style='vertical-align: baseline; margin-right: 5px;'/>${company}</span>` : ""} </div> <div style='display: table-cell; width: 10%; vertical-align: middle;'> <span class='fwi-arrow-right arrow-right' style='position: initial; vertical-align:  middle;'/> </div> </div> </li>`;
              ulc.append(li);
            }
          }
          return i += 1;
        });
        ulc.show();
        return ulc.listview('refresh');
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      btnContactClicked(event) {
        var contact, contactID, iView, obj, ref, view;
        event.stopPropagation();
        event.preventDefault();
        obj = $(event.currentTarget);
        obj.addClass('contactSelected');
        contactID = obj.attr('data-contactID');
        contact = new ContactModel();
        contact.get_details_contact(this.usr.get('sessionID'), contactID);
        if (this.previousView === 'AddProject') {
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          return contact.on('change', _.bind(view.addedProjectGlobalContact, this, view));
        } else if (this.previousView === 'AddProjectCFields') { //TODO REFACTOR - USING addedProjectCfieldContact in Booking and Task
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          return contact.on('change', _.bind(view.addedProjectCfieldContact, this, view));
        } else if ((ref = this.previousView) === 'AddTodoAssigned' || ref === 'AddTodoRelated') {
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          return contact.on('change', _.bind(view.addedContactTodo, this, view, this.previousView));
        } else if (this.previousView === 'FormContactView') {
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          return contact.on('change', _.bind(view.addContactCfieldContact, this, view, this.previousView));
        } else {
          if (!ContactView) {
            ContactView = require("views/contact/ContactView");
          }
          view = new ContactView(this.usr, contact, this.contactsCol);
          return this.__go_to_contact_view(view);
        }
      }

      btnAddContactClicked(event) {
        var view;
        event.preventDefault();
        event.stopPropagation();
        this.contactsCol.get_companies(this.usr);
        if (!FormContactView) {
          FormContactView = require('views/contact/FormContactView');
        }
        view = new FormContactView(this.usr, this.contactsCol);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      inputSearchChanged(event) {
        var col, input, query;
        input = $(event.currentTarget);
        query = input.val();
        if (query.length >= 3) {
          col = this.contactsCol.findByNameOrCompany(query);
          return this.update_contact_list(col);
        } else if (query.length === 0) {
          return this.update_contact_list();
        }
      }

      contact_deleted() {
        return this.$el.find('#id-ul-listContacts').empty();
      }

      __go_to_contact_view(view) {
        var nextView;
        nextView = _.find($.mobile.jqmNavigator.getViews(), function(view) {
          return $(view.el).attr('id') === 'id-ContactView';
        });
        if (nextView) {
          //#console.log 'INDEX '+_.indexOf(nextView,$.mobile.jqmNavigator.getViews())
          return $.mobile.jqmNavigator.pushView(nextView, {
            transition: "none"
          });
        } else {
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

      __get_contacts_collection() {
        return this.contactsCol.get_contacts(this.usr).toJSON();
      }

    };
  });

}).call(this);
